/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByProfession;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidBodyType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Gender;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.humanoid.Race;
import technology.rocketjump.undermount.jobs.model.Profession;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CharacterViewPersistentSettings {
    private Gender gender;
    private Race race = Race.DWARF;
    private HumanoidBodyType bodyType;
    private Map<EntityAssetType, String> typeToUniqueNameMap = new HashMap<EntityAssetType, String>();
    private Color skinColor;
    private Color hairColor;
    private Color accessoryColor;
    @JsonIgnore
    private final HumanoidEntityAssetDictionary assetDictionary;
    @JsonIgnore
    private ObjectMapper mapper = new ObjectMapper();
    @JsonIgnore
    private final FileHandle settingsFile;
    @JsonIgnore
    private boolean isPersistable = false;
    private EntityAssetType humanoidBody = new EntityAssetType("HUMANOID_BODY");

    public CharacterViewPersistentSettings() {
        this.assetDictionary = null;
        this.settingsFile = null;
    }

    @Inject
    public CharacterViewPersistentSettings(HumanoidEntityAssetDictionary assetDictionary) throws IOException {
        this.isPersistable = true;
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.assetDictionary = assetDictionary;
        this.settingsFile = Gdx.files.internal("assets/character-viewer-settings.json");
        if (this.settingsFile.exists()) {
            String fileAsString = FileUtils.readFileToString(this.settingsFile.file(), "UTF-8");
            CharacterViewPersistentSettings persisted = (CharacterViewPersistentSettings)this.mapper.readValue(fileAsString, this.getClass());
            this.gender = persisted.gender;
            this.race = persisted.race;
            this.bodyType = persisted.bodyType;
            this.typeToUniqueNameMap = persisted.typeToUniqueNameMap;
            this.skinColor = persisted.skinColor;
            this.hairColor = persisted.hairColor;
            this.accessoryColor = persisted.accessoryColor;
        } else {
            this.persist();
        }
    }

    public void reloadFromSettings(Entity entity) {
        HumanoidEntityAttributes attributes = (HumanoidEntityAttributes)entity.getPhysicalEntityComponent().getAttributes();
        Map<EntityAssetType, EntityAsset> assetMap = entity.getPhysicalEntityComponent().getTypeMap();
        if (this.race != null) {
            attributes.setRace(this.race);
        }
        if (this.gender != null) {
            attributes.setGender(this.gender);
        }
        if (this.bodyType != null) {
            attributes.setBodyType(this.bodyType);
        }
        if (this.hairColor != null) {
            attributes.setHairColor(this.hairColor);
        }
        if (this.skinColor != null) {
            attributes.setSkinColor(this.skinColor);
        }
        if (this.accessoryColor != null) {
            attributes.setAccessoryColor(this.accessoryColor);
        }
        ProfessionsComponent professionsComponent = entity.getComponent(ProfessionsComponent.class);
        Profession primaryProfession = professionsComponent.getPrimaryProfession(new Profession());
        entity.getPhysicalEntityComponent().setBaseAsset(this.assetDictionary.getHumanoidEntityAsset(this.humanoidBody, attributes, primaryProfession));
        for (EntityAssetType entityAssetType : assetMap.keySet()) {
            if (entityAssetType == null) continue;
            assetMap.put(entityAssetType, this.assetDictionary.getHumanoidEntityAsset(entityAssetType, attributes, primaryProfession));
        }
        for (Map.Entry entry : this.typeToUniqueNameMap.entrySet()) {
            HumanoidEntityAsset assetFromDictionary;
            if (((String)entry.getValue()).equals(HumanoidEntityAssetsByProfession.NULL_ENTITY_ASSET.getUniqueName()) || !(assetFromDictionary = this.assetDictionary.getByUniqueName((String)entry.getValue())).matches(attributes, primaryProfession)) continue;
            assetMap.put(assetFromDictionary.getType(), assetFromDictionary);
        }
    }

    public void update(EntityAssetType assetType, HumanoidEntityAsset selectedAsset) {
        this.typeToUniqueNameMap.put(assetType, selectedAsset.getUniqueName());
        this.persist();
    }

    private void persist() {
        if (this.isPersistable) {
            try {
                String jsonData = this.mapper.writeValueAsString(this);
                FileUtils.write(this.settingsFile.file(), jsonData);
            }
            catch (IOException e) {
                System.err.println("Error while writing " + this.getClass().toString() + " to file, " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
        this.persist();
    }

    public Race getRace() {
        return this.race;
    }

    public void setRace(Race race) {
        this.race = race;
        this.persist();
    }

    public HumanoidBodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(HumanoidBodyType bodyType) {
        this.bodyType = bodyType;
        this.persist();
    }

    public Map<EntityAssetType, String> getTypeToUniqueNameMap() {
        return this.typeToUniqueNameMap;
    }

    public void setTypeToUniqueNameMap(Map<EntityAssetType, String> typeToUniqueNameMap) {
        this.typeToUniqueNameMap = typeToUniqueNameMap;
    }

    public void setSkinColor(Color skinColor) {
        this.skinColor = skinColor;
        this.persist();
    }

    public Color getSkinColor() {
        return this.skinColor;
    }

    public Color getHairColor() {
        return this.hairColor;
    }

    public void setHairColor(Color hairColor) {
        this.hairColor = hairColor;
        this.persist();
    }

    public Color getAccessoryColor() {
        return this.accessoryColor;
    }

    public void setAccessoryColor(Color accessoryColor) {
        this.accessoryColor = accessoryColor;
        this.persist();
    }
}

